/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.service.config;

import com.ibm.hwmca.fw.service.config.XMLListParser;
import com.ibm.hwmca.fw.service.config.XMLMapParser;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.XMLParsingException;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DirParseUtils {
    private static final String TRACE_MASKT = "XRVFxxxT";
    private static final String TRACE_MASKF = "XRVFxxxF";
    private static final String TRACE_MASKD = "XRVFxxxD";

    public static Map parseSubDirOverride(XMLMapParser p, String parentDir, String subDir) throws XMLParsingException {
        return DirParseUtils.parseSubDirOverride(p, new File(parentDir), new File(subDir));
    }

    public static Map parseSubDirOverride(XMLMapParser p, File parentDir, File subDir) throws XMLParsingException {
        Map returnMap = null;
        if (!parentDir.isDirectory()) {
            Trace.trace(TRACE_MASKF, parentDir + " is not a directory");
            return null;
        }
        returnMap = DirParseUtils.parseDir(p, parentDir);
        if (subDir != null && !subDir.isDirectory()) {
            Trace.trace(TRACE_MASKF, subDir + " is not a directory");
            return returnMap;
        }
        Map overrideMap = DirParseUtils.parseDir(p, subDir);
        if (overrideMap != null) {
            returnMap.putAll(overrideMap);
        }
        return returnMap;
    }

    public static Map parseDir(XMLMapParser p, File directory) throws XMLParsingException {
        File[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File pathName) {
                return pathName.getName().toLowerCase().endsWith(".xml");
            }
        });
        if (files.length == 0) {
            Trace.trace(TRACE_MASKF, directory + " doesn't contain any XML files");
            return null;
        }
        HashMap returnMap = new HashMap();
        for (int aii = 0; aii < files.length; ++aii) {
            returnMap.putAll(p.parseXML(files[aii]));
        }
        return returnMap;
    }

    public static List parseDir(XMLListParser p, File directory) throws XMLParsingException {
        File[] files = directory.listFiles(new FileFilter(){

            public boolean accept(File pathName) {
                return pathName.getName().toLowerCase().endsWith(".xml");
            }
        });
        if (files.length == 0) {
            Trace.trace(TRACE_MASKF, directory + " doesn't contain any XML files");
            return null;
        }
        LinkedList returnList = new LinkedList();
        for (int aii = 0; aii < files.length; ++aii) {
            returnList.addAll(p.parseXML(files[aii]));
        }
        return returnList;
    }
}

